/*==============================================================================
Master do file. 

Creates the data used in:

Olivier Coibion, Yuriy Gorodnichenko and Dmitri Koustas
"Amerisclerosis? The Puzzle of Rising U.S. Unemployment Persistence." 
Brookings Papers on Economic Activity. 
Fall 2013 BPEA Conference.
http://www.brookings.edu/~/media/Projects/BPEA/Fall%202013/2013b%20coibion%20unemployment%20persistence.pdf

Contact with any questions:
Yuriy Gorodnichenko ygorodni@econ.berkeley.edu
Dmitri Koustas dkoustas@econ.berkeley.edu 

Last modified: 10.23.13 
==============================================================================*/
clear all
set more off

* ------------------------------------------------------------------------------
* Set paths  
* ------------------------------------------------------------------------------

*Insert your own local path here: 
local path "/accounts/projects/ygorodni/hysteresis/Documents/Hysteresis/PUBLIC RELEASE"

*Insert scratch directory for large data files:
global scratch "/scratch/public/hysteresis_files/"

****************** No need to modify anything below this line ******************
cd "`path'"
*do files directory 	
global do_files "`path'/do_files_CGK_PUBLIC_RELEASE"
*directory of .csv and .xls files to be insheeted  
global insheet_files "`path'/insheet_files_CGK_PUBLIC_RELEASE"
*directory where .dta files will be saved
global dta_files "`path'//dta_files_CGK_PUBLIC_RELEASE"
*directory for regression output
global output "`path'/output_CGK_PUBLIC_RELEASE"
*directory for figures 
global figures "`path'/figures_CGK_PUBLIC_RELEASE"
*directory for log files
global log_files "`path'/log_files_CGK_PUBLIC_RELEASE"

capture log close
log using "$log_files/log_$S_DATE", replace

* ------------------------------------------------------------------------------
* Steps 0001 - 0100 
* These steps create employment data for all countries in sample 
* ------------------------------------------------------------------------------

display "$S_TIME"
#delim ;
local step0 
"
"step0001.1 - merge eurostat yearbooks - labor.do" 
"step0001.2 - merge eurostat yearbooks - population.do" 
"step0001.3 - merge all yearbook data and modify codes.do"

"step0002 - Eurostat FOCUS and RAPID REPORTS - labor.do"
"step0003 - Eurostat website.do"

"step0004 - Austria - labor.do"
"step0005 - Denmark - labor.do"
"step0006 - Finland - labor.do"
"step0007 - France - labor.do"
"step0008 - Italy - labor.do"
"step0009 - Spain - labor.do"
"step0010 - Sweden - labor.do"
"step0011 - UK 1971 Census.do"
"step0012 - UK 1981 Census.do"
"step0013 - UK 1991 Census.do"
"step0014 - EU - IPUMS Intl -  labor.do"
"step0015 - US - 1970 - labor IC.do"
"step0016 - US - labor.do"
"step0017 - Canada - labor IC.do"
"step0018 - Canada - labor.do"
"step0100 - merge and clean labor data.do"
";
#delim cr

foreach dofile in `step0'  {

	do "$do_files/`dofile'"

}

display "$S_TIME"
*/

* ------------------------------------------------------------------------------
* Steps 0101-0200
* Initial Conditions (IC) - 
* First year of available data circa 1970s for each country
* ------------------------------------------------------------------------------
 
display "$S_TIME"
#delim ;
local step1 
"
"step0101 - IC - EU - age.do"
"step0102 - IC - EU - industry.do"
"step0103 - IC - EU - GDP.do"
"step0104 - IC - UK - migration.do"
"step0105 - IC - EU - migration.do"
"step0106 - IC - CA - migration.do"
"step0107 - IC - EU - IPUMS Intl.do"
"step0108 - IC - EU - education.do"
"step0109 - IC - UK - LFS - education.do"
"step0110 - IC - CA EU - HH.do"
"step0111 - IC - EU - FEMP.do"
"step0112 - IC - UK  1981 SWS - industry.do"
"step0113 - IC - US - GDP industry.do"
"step0114 - IC - CA - GDP industry.do"
"step0115 - IC - urbanization.do"
"step0200 - merge and clean initial conditions.do"
" ;
#delim cr

foreach dofile in `step1'  {

	do "$do_files/`dofile'"

}

*-------------------------------------------------------------------------------
* Steps 0201 - Time series conditions to be merged with IC 
*-------------------------------------------------------------------------------

display "$S_TIME"
#delim ;
local step2
"
"step0201 - infrastructure.do"
" ;
#delim cr

foreach dofile in `step2'  {

	do "$do_files/`dofile'"

}

*-------------------------------------------------------------------------------
* Steps 300 - Merge IC and Labor Data 
*-------------------------------------------------------------------------------
display "$S_TIME"
#delim ;
local step3
"
"step0300 - merge labor data and initial conditions.do"
"step0301 - Clean up, ipolate missing values.do"
" ;
#delim cr

foreach dofile in `step3'  {

	do "$do_files/`dofile'"

}

*-------------------------------------------------------------------------------
* Steps 400 - Prepare WVS Data 
** Step 0400: Breaks up composite regions into individual regions, for WVS merge 
** Step 0401: Crosswalk between NUTS 2006, WVS and NUTS 2010 
** Step 0402: collapse all WVS variables by NUTS
** Step 0403: process/clean up WVS collapse
*-----------------------------------------------------------------------------*/

display "$S_TIME"
#delim ;
local step4

"
"step0400 - prepare region codes for merge.do"
"step0401 - NUTS 2006 to WVS to NUTS 2010 crosswalk.do"
"step0402 - collapse World Values Survey.do"
"step0403 - process WVS collapse.do"
" ;
#delim cr

foreach dofile in `step4'  {

	do "$do_files/`dofile'"

}

display "$S_TIME"

/*------------------------------------------------------------------------------
* Steps 500 - Time Series of U.S. Initial Conditions
*-----------------------------------------------------------------------------*/


display "$S_TIME"
#delim ;
local step5

"
"step0500 - TS - US - CENS.do"
"step0501 - TS - US - CPS.do"
"step0502 - TS - US - BEA.do"
"step0503 - TS - US - merge US time series.do"
" ;
#delim cr

foreach dofile in `step5'  {

	do "$do_files/`dofile'"

}

display "$S_TIME"





